﻿/*
	VERSION:		1.3
	
	USAGE:
		#include "addAutoScroll.as"
		scroll_obj = addAutoScroll( MAP_MC, PLAYER_MC );
	
	NOTE:
		The scroll target_mc can be safely left undefined.
		This merely stops the scrolling.
		
	NOTE:
		This system uses a setInterval.
		setInterval() doesn't always loop smoothly.
	
	WHAT THIS DOES:
		This adds automatic scrolling to the map system.
*/
addAutoScroll = function( map_mc, target_mc, screenWidth, screenHeight, smoothness )
{
	// create container
	var _this = new Object();
	
	// store parameters
	_this.map_mc = map_mc;
	_this.target_mc = target_mc;
	_this.screenWidth = (screenWidth) ? screenWidth : 320;
	_this.screenHeight = (screenHeight) ? screenHeight : 240;
	_this.smoothness = (smoothness) ? smoothness : 1;
	
	// Loop
	_this.loop = function()
	{
		if(_this.target_mc)
		{
			_this.map_mc.scroll( _this.target_mc._x, _this.target_mc._y, _this.screenWidth, _this.screenHeight, _this.smoothness );
		}// if:  a scroll target exists
	}// loop()
	_this.loopInterval = setInterval( _this.loop, 1000/30 );		// 30 FPS
	
	// return this object
	return _this;
}// addAutoScroll()